<?php
/**
 * Bluga APIs factory for Zend Framework.
 * Written by Cristi Nicolescu
 * http://mandagreen.com/code/webthumb/
 */

/**
 * Basic usage
 *
 *   $apikey = '...';
 *   $url = 'http://www.google.com/';
 *   try {
 *     $webthumb = Oxygen_Service_Bluga::webthumb($apikey);
 *     $status = $webthumb->checkCreditStatus();
 *     $reqUsed = $status['used-this-month'];
 *
 *     $job = $webthumb->addUrl($url, 'small', 1024, 768);
 *     $webthumb->submitRequests();
 *     while( !$webthumb->readyToDownload() ) {
 *       sleep(5);
 *       echo "Checking Job Status\n";
 *       $webthumb->checkJobStatus();
 *     }
 *
 *     $webthumb->fetchToFile($job, $job->status->id . '_thumb.jpg', 'small');
 *     $webthumb->fetchToFile($job, $job->status->id . '_normal.jpg', 'medium');
 *     $webthumb->fetchToFile($job, $job->status->id . '_large.jpg', 'medium2');
 *
 *   	 $status = $webthumb->checkCreditStatus();
 *   	 $reqUsed = $status['used-this-month'] - $reqUsed;
 *     echo '<div>Req used: ' . $reqUsed . '</div>';
 *   }
 *   catch( Exception $e ) {
 *     echo $e->getMessage();
 *   }
 */

/**
 * @see Oxygen_Service_Bluga_Webthumb
 */
require_once('Oxygen/Service/Bluga/Webthumb.php');


class Oxygen_Service_Bluga {
	public static function webthumb( $apikey = null ) {
		return new Oxygen_Service_Bluga_Webthumb($apikey);
	}
}