<?php
/**
 * @Oxygen_Exception.php v. 1.0
 * @Created on Aug 16, 2008
 */

class Oxygen_Exception extends Exception {
	function getStackTrace() {
		$ret = '<pre style="width: 95%; padding: 1%; margin: 0 auto; font-size: 12px; line-height: 17px; border: 1px solid #555;">';
		$ret .= '<h2 style="font-size: 14px; margin: 2px 0;">New exception caught: ' . $this->getMessage() . ($this->getCode() ? ' (Error ' . $this->getCode() . ')' : '') . '</h2>';
		$argsString = '';
		$trace = $this->getTrace();
		for($k = 0, $n = count($trace); $k < $n; $k++) {
			$line = $trace[$k];
//			$argsString = '';
//			if( count($line['args']) ) {
//				$argsString = implode(', ', $line['args']);
//			}

			$ret .= '#' . ($k + 1);
			if( isset($line['file']) ) {
				$ret .= ' - ' . $line['file'];
			}
			if( isset($line['line']) ) {
				$ret .= ' (line ' . $line['line'] . ')';
			}
			if( isset($line['class']) ) {
				$ret .= ': ' . $line['class'] . '::';
			}
			if( isset($line['function']) ) {
				$ret .= $line['function'] . '(' . $argsString . ')';
			}
			$ret .=  "\n";
		}

		$ret .= '</pre>';
		return $ret;
	}
}