var pCarousel = {
	animationId: null,
	animationDir: 'right',
	
	//time in miliseconds to wait before scrolling
	animationTimeout: 1500,
	
	//time in miliseconds for the scrolling transition
	animationSpeed: 200,
	
	
	init: function(carousel) {
		// Disable autoscrolling if the user clicks the prev or next button.
		carousel.clip.hover(function() { pCarousel.halt() }, function() { pCarousel.animate(carousel); });
		pCarousel.animate(carousel);
		
		jQuery('a.pCarouselNext').bind('click', function() {
        pCarousel.halt();
        carousel.next();
        return false;
    });
		
		jQuery('a.pCarouselPrev').bind('click', function() {
        pCarousel.halt();
        carousel.prev();
        return false;
    });
		
		jQuery('a.pCarouselStop').bind('click', function() {
        pCarousel.halt();
        return false;
    });
		
		jQuery('a.pCarouselStart').bind('click', function() {
        if( pCarousel.animationId ) { //already running
        	pCarousel.halt();
        	carousel.scroll(1);
        	pCarousel.animationDir = 'right';
        }

      	pCarousel.animate(carousel);
        return false;
    });
		
	},
	
	animate: function(carousel) {
		pCarousel.animationId = setInterval( function() {
			if( carousel.last == carousel.options.size ) { pCarousel.animationDir = 'left'; }
			else if( carousel.first == 1 ) { pCarousel.animationDir = 'right'; }
	
			if( pCarousel.animationDir == 'right' ) { carousel.next(); }
			else { carousel.prev(); }
		}, pCarousel.animationTimeout );
	},
	
	halt: function() {
		if( pCarousel.animationId ) {
			clearInterval(pCarousel.animationId);
		}
	}
	
};

jQuery(document).ready(function() {
	jQuery('#pCarousel').jcarousel({
		wrap: null,
		scroll: 1,
		visible: 3,
		initCallback: pCarousel.init,
		easing: 'linear',
		animation: pCarousel.animationSpeed,
		buttonPrevHTML: null,
		buttonNextHTML: null
	});
});
